import streamlit as st

st.header("Arquitectura del proyecto")
st.write("""
La arquitectura de la aplicación de inteligencia artificial se basa en una estructura de capas. Comenzamos con el usuario, que se conecta a través de una computadora o celular, y accede a la capa de presentación o front-end. Esta consta de dos APIs principales: "login/registro" y "suscripción". Estas APIs separan los procesos relacionados con el inicio de sesión, el registro y la gestión de suscripciones.

Además, en esta arquitectura, se utiliza una función lambda que se encarga de gestionar el envío de notificaciones a los usuarios. Esto permite una mayor flexibilidad y escalabilidad.

En cuanto al alojamiento de la aplicación, todos estos componentes, incluyendo las APIs y la función lambda, se encuentran alojados en AWS (Amazon Web Services). Utilizar AWS para alojar la aplicación proporciona beneficios como escalabilidad, alta disponibilidad y facilidad de implementación.
""")

st.image("0-1 Pysentimiento_files/arquitectura.jpg", caption="Arquitectura del proyecto")

st.write("""
El soporte técnico puede involucrar un equipo que brindan asistencia y resuelven cualquier problema que pueda surgir.

Después de la capa de presentación, la arquitectura de la aplicación se integra con el backend, que es el encargado de unificar todos los componentes principales del proyecto. El backend está dividido en tres grandes subgrupos.

El primer subgrupo se encuentra alojado en la nube de AWS y está encargado de almacenar y gestionar los datos de la aplicación. Esta parte del backend se encarga de manejar el almacenamiento de información relevante, como perfiles de usuarios, historiales de suscripción, entre otros.

El segundo subgrupo del backend es la parte de inteligencia artificial. Aquí es donde se utiliza para realizar las predicciones. 

El tercer subgrupo consiste en una herramienta de web scraping. Esta herramienta se utiliza para recopilar información relevante de diversas fuentes en línea y alimentar al modelo de IA. Esta parte del backend funciona en una instancia de AWS y se encarga de extraer y preparar los datos necesarios para el funcionamiento del modelo.

Dentro de la parte alojada en la nube, también se incluyen funcionalidades adicionales como la integración con una pasarela de pago. Esta integración permite gestionar los cobros de suscripción. Para esto último, se utiliza una función lambda que se ejecuta cuando finaliza una suscripción, permitiendo realizar el cobro correspondiente.

Por último, la arquitectura de la aplicación incluye la gestión de la base de datos. Esta se almacena en la nube para garantizar que la información sea segura y no se pierda. Dado que esta base de datos contiene datos críticos para el funcionamiento de la aplicación.

Además, se guarda el modelo entrenado en un formato específico, como pkl, h5, pb, u otros. Este formato permite conservar el modelo de IA en un estado óptimo para su posterior uso y realizar predicciones de manera eficiente. Al elegir un formato adecuado, se facilita la carga y el despliegue del modelo en el entorno de producción.

Asimismo, los datos recopilados a través del web scraping y otros medios se almacenan en una base de datos elástica. Esta base de datos está diseñada para manejar un crecimiento constante en la cantidad de datos almacenados. La elasticidad permite adaptarse a medida que la aplicación recopila más información con el tiempo, asegurando que no se vea afectada la capacidad de almacenamiento y consulta de los datos.
         """)